package apps.pint;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
	

public class PintLogin extends JDialog implements KeyListener{
	
	private PintUI ui;
	
	JTextField confIDField ;
	
	JCheckBox useDS;
	
	JPasswordField confPassField;
	
	//JTextField confTopicField;
	
	JButton okButton;
	
	
	public PintLogin(PintUI ui) {
		super();
		this.ui = ui;
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				System.exit(0);}
													});
		

		
		
		this.setTitle("Pint Login:");
		
		JPanel dialogPane = new JPanel();
		
		JPanel infoPane = new JPanel();
		
		JPanel aPanel = new JPanel();
			
		confIDField = new JTextField("");
		int fieldHeight = confIDField.getPreferredSize().height;
		
		Dimension labelDim = new Dimension(95,fieldHeight);
		Dimension fieldDim = new Dimension(150,fieldHeight);
		
		confIDField.setPreferredSize(fieldDim);
		
		JLabel IDLabel = new JLabel("Login:");
		IDLabel.setLabelFor(confIDField);
		IDLabel.setPreferredSize(labelDim);
				
		
		aPanel.add(IDLabel);
		aPanel.add(confIDField);
		aPanel.setLayout(new GridBagLayout());
				
		
		
		JPanel bPanel = new JPanel();
		
		confPassField = new JPasswordField("");
		confPassField.setPreferredSize(fieldDim);
		
		JLabel passLabel = new JLabel("Password:");
		
		passLabel.setLabelFor(confPassField);
		passLabel.setPreferredSize(labelDim);
				
		bPanel.add(passLabel);
		bPanel.add(confPassField);
		bPanel.setLayout(new GridBagLayout());
				
		
		
		
		JPanel cPanel = new JPanel();
		
		useDS = new JCheckBox("Use directory services", true);
		cPanel.add(useDS);
		
		
		
		infoPane.add(aPanel);
		infoPane.add(Box.createRigidArea(new Dimension(0,5)));
		infoPane.add(bPanel);
		infoPane.add(Box.createRigidArea(new Dimension(0,5)));
		infoPane.add(cPanel);
		
		infoPane.setLayout(new BoxLayout(infoPane,BoxLayout.Y_AXIS));
		infoPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		
		JPanel buttonsPane = new JPanel();
		
		okButton = new JButton("OK");
		okButton.addActionListener(ui);
		
		//set return in any field to activate OK button
		confIDField.addKeyListener(this);
		confPassField.addKeyListener(this);
		
		JButton quitButton = new JButton("Quit");
		quitButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae){
			System.exit(0);}});
										
		buttonsPane.add(Box.createHorizontalGlue());
		buttonsPane.add(quitButton);
		buttonsPane.add(Box.createRigidArea(new Dimension(10,0)));
		buttonsPane.add(okButton);
		
		buttonsPane.setLayout(new BoxLayout(buttonsPane,BoxLayout.X_AXIS));
		buttonsPane.setBorder(BorderFactory.createEmptyBorder(0,10,10,10));
		
		dialogPane.add(infoPane);
		dialogPane.add(buttonsPane);
		dialogPane.setLayout(new BoxLayout(dialogPane,BoxLayout.Y_AXIS));
		
		this.getContentPane().add(dialogPane);
		this.getRootPane().setDefaultButton(okButton);
		this.setLocation(550,300);
		this.setModal(true);
		this.setResizable(false);
		this.pack();
		
		
	}
	
	
	public void present() {
		
		this.setVisible(true);
		this.toFront();
	}
	
	
	

	
	public Object getLoginButton() {
		return this.okButton;
	}
	
	public void sendLogin() {
		String p = new String(confPassField.getPassword()) ;
		ui.login(this.confIDField.getText(),
				 p, 
				 this.useDS.isSelected());
	}
	
	public void fail() {
		this.setVisible(false);
		confPassField.setText("");
		try {
			Thread.currentThread().sleep(100);
		}catch (InterruptedException e) {}
		this.setVisible(true);
	}
	
	
	/* **************key Listener***********************/

	public void keyPressed(KeyEvent ke) {
		if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
			okButton.doClick();
		}
	}
	public void keyTyped(KeyEvent ke) {}
	public void keyReleased(KeyEvent ke) {}
	
	
}
